********************************************************************************
********************************************************************************
*****************English variable labels for classification variables **********
********			BIBB/BAuA Youth Employment Survey 2012               *******
*****************											********************
*****************              SUF 4.0               		********************
*****************		BIBB-FDZ, July 2015					********************
********************************************************************************
********************************************************************************

/*
clear
cd 
set more off, perm
set logtype text
log using testat.txt, replace  
use ETB2012_Los2_suf.dta
*/

/*
Please notice:
For the following classification are no translations offered because they are 
inherent to the occupational system in Germany:
 -	Berufsabschnitte laut KldB 1992 (EB_berufsabschnitte)

Further we offer no translation for the Classification of Occupations 1992 (EB92g). 
One can use one of the other administrative classifications of occupations 
namely the International Standard Classification of Occupations 1988,
the International Standard Classification of Occupations 2008 and the 
Classification of Occupations 2010. 
*/

********************************************************************************
***NUTS-2
#delimit ;
label define nuts2_lbl_eng
10	"Schleswig-Holstein"
20	"Hamburg"
31	"Statistical region Brunswick"
32	"Statistical region Hanover"
33	"Statistical region Lneburg"
34	"Statistical region Weser-Ems"
40	"Bremen"
51	"Dsseldorf"
53	"Cologne"
55	"Mnster"
57	"Detmold"
59	"Arnsberg"
64	"Darmstadt"
65	"Giessen"
66	"Kassel"
71	"Statistical region Koblenz"
72	"Statistical region Trier"
73	"Statistical region Rhine-Hesse-Palatinate"
81	"Stuttgart"
82	"Karlsruhe"
83	"Freiburg"
84	"Tbingen"
91	"Upper Bavaria"
92	"Lower Bavaria"
93	"Upper Palatinate"
94	"Upper Franconia"
95	"Middle Franconia"
96	"Lower Franconia"
97	"Swabia"
100	"Saarland"
110	"Berlin"
121	"Statistical region Brandenburg Northeast"
122	"Statistical region Brandenburg Southwest"
130	"Mecklenburg-Western Pomerania"
141	"Directorate region Chemnitz"
142	"Directorate region Dresden"
143	"Directorate region Leipzig"
150	"Saxony-Anhalt"
160	"Thuringia";
#delimit cr

lab val Nuts2 nuts2_lbl_eng


***KldB2010 2-digit.
#delimit ;
label define kldb2010_2d_eng
 -55 "Consultant"
 -54 "Assessor"
 -53 "Management assistants"
 -52 "Managing director"
 -51 "Jobs operations manager, executive employee"
 -50 "Adviser, consultant"
 -32 "Diploma, Master"
 -31 "Bachelor"
 -30 "Student research assistant"
 -21 "Temporary worker"
 -20 "Service provider"
 -19 "Federal volunteer service"
 -18 "Family workers"
 -17 "Freelancer, self-employed person"
 -16 "Trainees"
 -15 "Engineer"
 -14 "Technician"
 -13 "Foreman, master craftsman"
 -12 "Workers, skilled workers, unskilled workers"
 -11 "Apprentices"
 -10 "Temporary staff"
-1  "not assignable"
11	"Occupations in agriculture, forestry, and farming"
12	"Occupations in gardening and floristry"
21	"Occupations in production and processing of raw materials, glass- and ceramic-making and -processing"
22	"Occupations in plastic-making and -processing, and wood-working and -processing"
23	"Occupations in paper-making and -processing, printing, and in technical media design"
24	"Occupations in metal-making and -working, and in metal construction"
25	"Technical occupations in machine-building and automotive industry"
26	"Occupations in mechatronics, energy electronics and electrical engineering"
27	"Occupations in technical research and development, construction, and production planning and scheduling"
28	"Occupations in textile- and leather-making and -processing"
29	"Occupations in food-production and -processing"
31	"Occupations in construction scheduling, architecture and surveying"
32	"Occupations in building construction above and below ground"
33	"Occupations in interior construction"
34	"Occupations in building services engineering and technical building services"
41	"Occupations in mathematics, biology, chemistry and physics"
42	"Occupations in geology, geography and environmental protection"
43	"Occupations in computer science, information and communication technology"
51	"Occupations in traffic and logistics (without vehicle driving)"
52	"Drivers and operators of vehicles and transport equipment"
53	"Occupations in safety and health protection, security and surveillance"
54	"Occupations in cleaning services"
61	"Occupations in purchasing, sales and trading"
62	"Sales occupations in retail trade"
63	"Occupations in tourism, hotels and restaurants"
71	"Occupations in business management and organisation"
72	"Occupations in financial services, accounting and tax consultancy"
73	"Occupations in law and public administration"
81	"Medical and health care occupations"
82	"Occupations in non-medical healthcare, body care, wellness and medical technicians"
83	"Occupations in education and social work, housekeeping, and theology"
84	"Occupations in teaching and training"
91	"Occupations in in philology, literature, humanities, social sciences, and economics"
92	"Occupations in advertising and marketing, in commercial and editorial media design"
93	"Occupations in product design, artisan craftwork, fine arts and the making of musical instruments "
94	"Occupations in the performing arts and entertainment"
01	"Armed forces personnel", replace;
#delimit cr

lab val F100_kldb2010_2d kldb2010_2d_eng


***ISCO 2008 2-digit.
#delimit ;
label define isco08_2d_eng
 -55 "Consultant"
 -54 "Assessor"
 -53 "Management assistants"
 -52 "Managing director"
 -51 "Jobs operations manager, executive employee"
 -50 "Adviser, consultant"
 -32 "Diploma, Master"
 -31 "Bachelor"
 -30 "Student research assistant"
 -21 "Temporary worker"
 -20 "Service provider"
 -19 "Federal volunteer service"
 -18 "Family workers"
 -17 "Freelancer, self-employed person"
 -16 "Trainees"
 -15 "Engineer"
 -14 "Technician"
 -13 "Foreman, master craftsman"
 -12 "Workers, skilled workers, unskilled workers"
 -11 "Apprentices"
 -10 "Temporary staff"
-1  "not assignable"
  11 "Chief executives, senior officials and legislators"
  12 "Administrative and commercial managers"
  13 "Production and specialised services managers"
  14 "Hospitality, retail and other services managers "
  21 "Science and engineering professionals"
  22 "Health professionals"
  23 "Teaching professionals "
  24 "Business and administration professionals"
  25 "Information and communications technology professionals" 
  26 "Legal, social and cultural professionals "
  31 "Science and engineering associate professionals"
  32 "Health associate professionals"
  33 "Business and administration associate professionals"
  34 "Legal, social, cultural and related associate professionals"
  35 "Information and communications technicians"
  41 "General and keyboard clerks"
  42 "Customer services clerks"
  43 "Numerical and material recording clerks"
  44 "Other clerical support workers "
  51 "Personal service workers"
  52 "Sales workers"
  53 "Personal care workers"
  54 "Protective services workers"
  61 "Market-oriented skilled agricultural workers"
  62 "Market-oriented skilled forestry, fishery and hunting workers"
  63 "Subsistence farmers, fishers, hunters and gatherers"
  71 "Building and related trades workers, excluding electricians" 
  72 "Metal, machinery and related trades workers"
  73 "Handicraft and printing workers"
  74 "Electrical and electronic trades workers"
  75 "Food processing, wood working, garment and other craft and related trades workers"
  81 "Stationary plant and machine operators"
  82 "Assemblers"
  83 "Drivers and mobile plant operators"
  91 "Cleaners and helpers"
  92 "Agricultural, forestry and fishery labourers"
  93 "Labourers in mining, construction, manufacturing and transport"
  94 "Food preparation assistants"
  95 "Street and related sales and service workers"
  96 "Refuse workers and other elementary workers "
  01 "Commissioned armed forces officers"
  02 "Non-commissioned armed forces officers"
  03 "Armed forces occupations, other ranks", replace ;
#delimit cr

lab val F100_isco08_2d isco08_2d_eng



***ISCO 1988 2-digit.
#delimit ;
label define isco88_2d_eng 
-1  "not assignable"
11 "Legislators and senior officials"
12 "Corporate managers"
13 "General managers"
21 "Physical, mathematical.and engineering science professionals"
22 "Life science and health professionals"
23 "Teaching professionals "
24 "Other professionals"
31 "Physical and engineering science associate professionals"
32 "Life science and health associate professionals "
33 "Teaching associate professionals"
34 "Other associate professionals"
41 "Office clerks"
42 "Customer services clerks"
51 "Personal and protective services workers"
52 "Models, salespersons and demonstrators"
61 "Market-oriented skilled agricultural and fishery workers"
62 "Subsistence agricultural and fishery workers"
71 "Extraction and building trades workers"
72 "Metal, machinery and related trades workers"
73 "Precision, handicraft, printing and related trades workers"
74 "Other craft and related trades workers"
81 "Stationary-plant and related operators"
82 "Machine operators and assemblers"
83 "Drivers and mobile-plant operators"
91 "Sales and services elementary occupations"
92 "Agricultural, fishery and related labourers"
93 "Labourers in mining, construction, manufacturing and transport"
1 "Armed forces "
99 "no isco88 label: workers without specification";
#delimit cr

lab val F100_isco88_2d isco88_2d_eng



***Wirtschaftszweige 2008.
#delimit ;
label define wz2008_eng
-1  "not assignable"
1 "Crop and animal production, hunting and related service activities "
2 "Forestry and logging "
3 "Fishing and aquaculture "
5 "Mining of coal and lignite "
6 "Extraction of crude petroleum and natural gas "
7 "Mining of metal ores "
8 "Other mining and quarrying "
9 "Mining support service activities "
10 "Manufacture of food products "
11 "Manufacture of beverages "
12 "Manufacture of tobacco products "
13 "Manufacture of textiles "
14 "Manufacture of wearing apparel "
15 "Manufacture of leather and related products "
16 "Manufacture of wood and of products of wood and cork, except furniture; manufacture of articles of straw and plaiting materials "
17 "Manufacture of paper and paper products "
18 "Printing and reproduction of recorded media "
19 "Manufacture of coke and refined petroleum products "
20 "Manufacture of chemicals and chemical products "
21 "Manufacture of pharmaceuticals, medicinal chemical and botanical products "
22 "Manufacture of rubber and plastics products "
23 "Manufacture of other non-metallic mineral products "
24 "Manufacture of basic metals "
25 "Manufacture of fabricated metal products, except machinery and equipment "
26 "Manufacture of computer, electronic and optical products "
27 "Manufacture of electrical equipment "
28 "Manufacture of machinery and equipment n.e.c. "
29 "Manufacture of motor vehicles, trailers and semi-trailers "
30 "Manufacture of other transport equipment "
31 "Manufacture of furniture "
32 "Other manufacturing "
33 "Repair and installation of machinery and equipment "
35 "Electricity, gas, steam and air conditioning supply "
36 "Water collection, treatment and supply "
37 "Sewerage "
38 "Waste collection, treatment and disposal activities; materials recovery "
39 "Remediation activities and other waste management services "
41 "Construction of buildings "
42 "Civil engineering "
43 "Specialized construction activities "
45 "Wholesale and retail trade and repair of motor vehicles and motorcycles "
46 "Wholesale trade, except of motor vehicles and motorcycles "
47 "Retail trade, except of motor vehicles and motorcycles "
49 "Land transport and transport via pipelines "
50 "Water transport "
51 "Air transport "
52 "Warehousing and support activities for transportation "
53 "Postal and courier activities "
55 "Accommodation "
56 "Food and beverage service activities "
58 "Publishing activities "
59 "Motion picture, video and television programme production, sound recording and music publishing activities "
60 "Programming and broadcasting activities "
61 "Telecommunications "
62 "Computer programming, consultancy and related activities "
63 "Information service activities "
64 "Financial service activities, except insurance and pension funding "
65 "Insurance, reinsurance and pension funding, except compulsory social security "
66 "Activities auxiliary to financial service and insurance activities "
68 "Real estate activities "
69 "Legal and accounting activities "
70 "Activities of head offices; management consultancy activities "
71 "Architectural and engineering activities; technical testing and analysis "
72 "Scientific research and development "
73 "Advertising and market research "
74 "Other professional, scientific and technical activities "
75 "Veterinary activities "
77 "Rental and leasing activities "
78 "Employment activities "
79 "Travel agency, tour operator, reservation service and related activities "
80 "Security and investigation activities "
81 "Services to buildings and landscape activities "
82 "Office administrative, office support and other business support activities "
84 "Public administration and defence; compulsory social security "
85 "Education "
86 "Human health activities "
87 "Residential care activities "
88 "Social work activities without accommodation "
90 "Creative, arts and entertainment activities "
91 "Libraries, archives, museums and other cultural activities "
92 "Gambling and betting activities "
93 "Sports activities and amusement and recreation activities "
94 "Activities of membership organizations "
95 "Repair of computers and personal and household goods "
96 "Other personal service activities "
97 "Activities of households as employers of domestic personnel "
98 "Undifferentiated goods- and services-producing activities of private households for own use "
99 "Activities of extraterritorial organizations and bodies "
201 "no official code: Undifferentiated industry"
202 "no official code: Undifferentiated service-producing"
203 "no official code: Undifferentiated services"
204 "no official code: Undifferentiated manufacturing trade" ;
#delimit cr
				
lab val Wz2008 wz2008_eng





***Wirtschaftszweige 2003.
#delimit ;
label define wz2003_eng
-1 "not assignable"
1 "Agriculture, hunting and related service activities "
2 "Forestry, logging and related service activities"
5 "Fishing, aquaculture and service activities incidental to fishing" 
10 "Mining of coal and lignite; extraction of peat" 
11 "Extraction of crude petroleum and natural gas; service activities incidental to oil and gas extraction, excluding surveying"  
12 "Mining of uranium and thorium ores "
13 "Mining of metal ores "
14 "Other mining and quarrying "
15 "Manufacture of food products and beverages "
16 "Manufacture of tobacco products "
17 "Manufacture of textiles "
18 "Manufacture of wearing apparel; dressing and dyeing of fur "
19 "Tanning and dressing of leather; manufacture of luggage, handbags, saddlery, harness and footwear "
20 "Manufacture of wood and of products of wood and cork, except furniture; manufacture of articles of straw and plaiting materials "
21 "Manufacture of paper and paper products "
22 "Publishing, printing and reproduction of recorded media "
23 "Manufacture of coke, refined petroleum products and nuclear fuel "
24 "Manufacture of chemicals and chemical products "
25 "Manufacture of rubber and plastics products "
26 "Manufacture of other non-metallic mineral products "
27 "Manufacture of basic metals "
28 "Manufacture of fabricated metal products, except machinery and equipment "
29 "Manufacture of machinery and equipment n.e.c. "
30 "Manufacture of office, accounting and computing machinery "
31 "Manufacture of electrical machinery and apparatus n.e.c. "
32 "Manufacture of radio, television and communication equipment and apparatus "
33 "Manufacture of medical, precision and optical instruments, watches and clocks "
34 "Manufacture of motor vehicles, trailers and semi-trailers "
35 "Manufacture of other transport equipment "
36 "Manufacture of furniture; manufacturing n.e.c. "
37 "Recycling "
38 "Electricity, gas, steam and hot water supply "
39 "Collection, purification and distribution of water "
40 "Electricity, gas, steam and hot water supply"
41 "Collection, purification and distribution of water"
45 "Construction "
50 "Sale, maintenance and repair of motor vehicles and motorcycles; retail sale of automotive fuel "
51 "Wholesale trade and commission trade, except of motor vehicles and motorcycles "
52 "Retail trade, except of motor vehicles and motorcycles; repair of personal and household goods "
55 "Hotels and restaurants "
60 "Land transport; transport via pipelines "
61 "Water transport "
62 "Air transport "
63 "Supporting and auxiliary transport activities; activities of travel agencies "
64 "Post and telecommunications "
65 "Financial intermediation, except insurance and pension funding "
66 "Insurance and pension funding, except compulsory social security "
67 "Activities auxiliary to financial intermediation "
70 "Real estate activities "
71 "Renting of machinery and equipment without operator and of personal and household goods "
72 "Computer and related activities "
73 "Research and development "
74 "Other business activities "
75 "Public administration and defence; compulsory social security "
80 "Education "
85 "Health and social work "
90 "Sewage and refuse disposal, sanitation and similar activities "
91 "Activities of membership organizations n.e.c. "
92 "Recreational, cultural and sporting activities "
93 "Other service activities "
95 "Activities of private households as employers of domestic staff "
96 "Undifferentiated goods-producing activities of private households for own use "
98 "no official code: Undifferentiated services"
97 "Undifferentiated service-producing activities of private households for own use "
99 "Extraterritorial organizations and bodies "
100 "no official code: Undifferentiated manufacturing trade" ;
#delimit cr

lab val Wz2003 wz2003_eng


****Sector03
#delimit ;
label def  lsector 
-4 "not assignable"
1 "Agriculture and forestry"
2 "Mining, Electricity, gas and water supply"
3 "Food products and tabacco"
4 "Manufacture of textiles and leather"
5 "Manufacture of wood and paper"
6 "Printing and service activities related to printing"
7 "Manufacture of chemicals"
8 "Manufacture of basic metals and fabricated metal products and electrical equipment"
9 "Manufacture of furniture and  jewellery"
10 "Recycling and disposal"
11 "Construction"
12 "Trade, Repare, Renting"
13 "Hotels and restaurants"
14 "Transport, storage and communication"
15 "Financial intermediation"
16 "Real estate"
17 "Data processing, research and business activities"
18 "Public administration"
19 "Education"
20 "Health and social work"
21 "Other services", replace;
#delimit cr

**********Branche03
#delimit ;
label def lbranche
-4 "not assignable"
1 "Agriculture/Mining/Electricity/Gas a. water supply"
2 "Other Manufacturing"
3 "Manufacture of basic metals and fabricated metal products and electrical equipment"
4 "Construction"
5 "Trade"
6 "Personal service activities"
7 "Financial intermediation"
8 "Business activities"
9 "Public administration/Education"
10 "Health and social work", replace ;
#delimit cr

quietly: labelbook, p
label drop `r(notused)'
